<?php
// src/Infrastructure/Repositories/MySQLCustomerRepository.php
class MySQLCustomerRepository implements CustomerRepositoryInterface {
    private $db;
    
    public function __construct() {
        $this->db = Database::getInstance()->getConnection();
    }
    
    public function save(Customer $customer) {
        $stmt = $this->db->prepare("
            INSERT INTO customers (phone_number, first_name, last_name, created_at) 
            VALUES (?, ?, ?, ?)
        ");
        $stmt->execute([
            $customer->getPhoneNumber(),
            $customer->getFirstName(),
            $customer->getLastName(),
            $customer->getCreatedAt()->format('Y-m-d H:i:s')
        ]);
        
        $customer->setId($this->db->lastInsertId());
        return $customer;
    }
    
    public function findById($id) {
        $stmt = $this->db->prepare("SELECT * FROM customers WHERE id = ?");
        $stmt->execute([$id]);
        $data = $stmt->fetch();
        
        if (!$data) return null;
        
        return $this->hydrate($data);
    }
    
    public function findByPhoneNumber($phoneNumber) {
        $stmt = $this->db->prepare("SELECT * FROM customers WHERE phone_number = ?");
        $stmt->execute([$phoneNumber]);
        $data = $stmt->fetch();
        
        if (!$data) return null;
        
        return $this->hydrate($data);
    }
    
    public function update(Customer $customer) {
        $stmt = $this->db->prepare("
            UPDATE customers 
            SET first_name = ?, last_name = ?, updated_at = NOW() 
            WHERE id = ?
        ");
        $stmt->execute([
            $customer->getFirstName(),
            $customer->getLastName(),
            $customer->getId()
        ]);
        
        return $customer;
    }
    
    private function hydrate($data) {
        $customer = new Customer(
            $data['phone_number'],
            $data['first_name'],
            $data['last_name']
        );
        
        $customer->setId($data['id']);
        
        return $customer;
    }
}